/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers.pages;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.server.handlers.pages.TestFileUtil;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.ArrayList;

public class StandaloneRunnerPage
implements Page {
    private final TestFileUtil testFileUtil;
    private final JstdTestCaseStore store;

    @Inject
    StandaloneRunnerPage(TestFileUtil testFileUtil, JstdTestCaseStore store) {
        this.testFileUtil = testFileUtil;
        this.store = store;
    }

    public void render(HtmlWriter writer, SlavePageRequest request) throws IOException {
        writer.startHead().writeTitle("Console Runner").writeExternalScript("/static/jstestdrivernamespace.js").writeExternalScript("/static/lib/json2.js").writeExternalScript("/static/lib/json_sans_eval.js").writeExternalScript("/static/lib/jquery-min.js").writeExternalScript("/static/standalonerunner.js").writeScript("jstestdriver.console = new jstestdriver.Console();jstestdriver.runner = jstestdriver.config.createRunner(\n  jstestdriver.config.createStandAloneExecutor);");
        ArrayList casesToWrite = Lists.newArrayList();
        if (request.getParameter("testcase_id") != null) {
            this.testFileUtil.writeTestFiles(writer, request.getParameter("testcase_id"));
        } else {
            for (JstdTestCase testCase : this.store.getCases()) {
                this.testFileUtil.writeTestFiles(writer, testCase.getId());
            }
        }
        writer.writeScript("jstestdriver.runner.listen(jstestdriver.manualResourceTracker.getResults());");
        writer.finishHead().startBody().finishBody().flush();
    }
}

