/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.TestErrors;
import com.google.jstestdriver.browser.BrowserActionRunner;
import com.google.jstestdriver.browser.BrowserCallable;
import com.google.jstestdriver.browser.BrowserControl;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.browser.BrowserSessionManager;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.util.RetryingCallable;
import com.google.jstestdriver.util.StopWatch;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionExecutorAction
implements Action {
    private static final Logger logger = LoggerFactory.getLogger(BrowserActionExecutorAction.class);
    private final JsTestDriverClient client;
    private final List<BrowserAction> actions;
    private final ExecutorService executor;
    private final Set<BrowserRunner> browserRunners;
    private final String captureAddress;
    private final long testSuiteTimeout;
    private final StopWatch stopWatch;
    private final BrowserSessionManager sessionManager;

    @Inject
    public BrowserActionExecutorAction(JsTestDriverClient client, List<BrowserAction> actions, ExecutorService executor, Set<BrowserRunner> browserRunners, @Named(value="captureAddress") String captureAddress, @Named(value="testSuiteTimeout") long testTimeout, StopWatch stopWatch, BrowserSessionManager sessionManager) {
        this.client = client;
        this.actions = actions;
        this.executor = executor;
        this.browserRunners = browserRunners;
        this.captureAddress = captureAddress;
        this.testSuiteTimeout = testTimeout;
        this.stopWatch = stopWatch;
        this.sessionManager = sessionManager;
    }

    @Override
    public RunData run(RunData runData) {
        this.stopWatch.start("run %s", this.actions);
        logger.trace("Starting BrowserActions {}.", this.actions);
        Collection<BrowserInfo> browsers = this.client.listBrowsers();
        if (browsers.size() == 0 && this.browserRunners.size() == 0 && this.actions.size() > 0) {
            throw new RuntimeException("No browsers available, yet actions requested. If running against a persistent server please capture browsers. Otherwise, ensure that browsers are defined.");
        }
        LinkedList<Callable<Collection<ResponseStream>>> runners = Lists.newLinkedList();
        for (BrowserInfo browserInfo : browsers) {
            runners.add(new BrowserActionRunner(browserInfo.getId().toString(), this.client, this.actions, this.stopWatch, runData.getTestCases(), this.sessionManager));
            logger.debug("Queueing BrowserActionRunner {} for {}.", this.actions, (Object)browserInfo);
        }
        for (BrowserRunner runner : this.browserRunners) {
            String browserId = this.client.getNextBrowserId();
            BrowserActionRunner actionRunner = new BrowserActionRunner(browserId, this.client, this.actions, this.stopWatch, runData.getTestCases(), this.sessionManager);
            runners.add(this.createBrowserManagedRunner(runData, runner, browserId, actionRunner));
            logger.debug("Queueing BrowserActionRunner {} for {}.", this.actions, (Object)runner);
        }
        LinkedList<Throwable> exceptions = Lists.newLinkedList();
        long currentTimeout = this.testSuiteTimeout;
        try {
            List results = this.executor.invokeAll(runners, currentTimeout, TimeUnit.SECONDS);
            for (Future result : results) {
                try {
                    for (ResponseStream response : (Collection)result.get()) {
                        runData = runData.recordResponse(response);
                    }
                }
                catch (CancellationException e) {
                    exceptions.add(new RuntimeException("Test run cancelled, exceeded " + currentTimeout + "s", e));
                }
                catch (ExecutionException e) {
                    exceptions.add(e.getCause());
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.executor.shutdownNow();
        }
        logger.debug("Finished BrowserActions {}.", this.actions);
        runData.finish();
        this.stopWatch.stop("run %s", this.actions);
        if (!exceptions.isEmpty()) {
            throw new TestErrors("Failures during test run.", exceptions);
        }
        return runData;
    }

    private Callable<Collection<ResponseStream>> createBrowserManagedRunner(RunData runData, BrowserRunner runner, String browserId, BrowserActionRunner actionRunner) {
        return new RetryingCallable<Collection<ResponseStream>>(runner.getNumStartupTries(), new BrowserCallable<Collection<ResponseStream>>(actionRunner, browserId, new BrowserControl(runner, this.captureAddress, this.stopWatch, this.client, runData.getTestCases())));
    }

    public List<BrowserAction> getActions() {
        return this.actions;
    }

    public RunTestsAction getRunTestsAction() {
        for (BrowserAction action : this.actions) {
            if (!(action instanceof RunTestsAction)) continue;
            return (RunTestsAction)action;
        }
        return null;
    }

    public JsTestDriverClient getClient() {
        return this.client;
    }
}

