/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

public class Lock {
    private final Object lock = new Object();
    private volatile boolean locked;
    private String sessionId = "";
    private long lastHeartBeat = 0L;

    public synchronized boolean tryLock(String sessionId) {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        this.sessionId = sessionId;
        return true;
    }

    public synchronized void unlock(String sessionId) {
        if (!this.locked || !this.sessionId.equals(sessionId)) {
            throw new IllegalStateException(String.format("Unlock error [%s : %s]", this.sessionId, sessionId));
        }
        this.locked = false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setLastHeartBeat(long lastHeartBeat) {
        this.lastHeartBeat = lastHeartBeat;
    }

    public long getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public synchronized void forceUnlock() {
        this.locked = false;
        this.sessionId = "";
    }
}

